/*
  Qtechknow Creator Kit: Circuit 9 - BounceLEDs
  
  'Bounces' LEDs back and forth from each side -
  
  Connect 8 LEDs to D2, 3, 4, 5, 6, 8, 9, & 12 each
 
  created by Qtechknow
  made on 10 July 15
*/

// LED pins in an array
const int ledPins[] = { 2, 3, 4, 5, 6, 8, 9, 12 };

void setup() {
  
  for(int i=0; i<8; i++) {
    pinMode(ledPins[i], OUTPUT);  // declare all pins as outputs
  }
  
}

void loop() {
  
  for(int y=0; y<8; y++) {
        digitalWrite(ledPins[y], HIGH);  // turn them on in a sequence
        delay(30);
      }
      for(int z=0; z<8; z++) {
        digitalWrite(ledPins[z], LOW);   // turn them off in a sequence
        delay(30);
      }
      for(int x=8; x>0; x--) {
        digitalWrite(ledPins[x], HIGH);  // turn them on going the other way
        delay(30);
      }
      digitalWrite(ledPins[0], HIGH);
      
      for(int w=8; w>0; w--) {
        digitalWrite(ledPins[w], LOW);   // turn them off going the other way
        delay(30);
      }   
     digitalWrite(ledPins[0], LOW);
}
